// Triangle.cpp
// Nasz pierwszy program OpenGL, ktry tylko rysuje trjkt na ekranie.

#include <GLTools.h>            // Otwarcie biblioteki OpenGL
#include <GLShaderManager.h>    // Klasa menedera programw cieniujcych

#ifdef __APPLE__
#include <glut/glut.h>          // Wersja OS X biblioteki GLUT
#else
#define FREEGLUT_STATIC
#include <GL/glut.h>            // Odpowiednik FreeGlut dla Windows
#endif

GLBatch	triangleBatch;
GLShaderManager	shaderManager;

///////////////////////////////////////////////////////////////////////////////
// Zmieni si rozmiar okna lub okno zostao wanie utworzone. W obu przypadkach musimy
// sprawdzi wymiary tego okna, aby ustawi obszar widoku i utworzy macierz rzutowania.
void ChangeSize(int w, int h)
    {
	glViewport(0, 0, w, h);
    }


///////////////////////////////////////////////////////////////////////////////
// Ta funkcja wykonuje wszystkie dziaania zwizane z inicjalizowaniem w kontekcie renderowania. 
// Jest to pierwsza okazja do wykonania jakich zada zwizanych z OpenGL.
void SetupRC()
	{
	// Niebieskie to
	glClearColor(0.0f, 0.0f, 1.0f, 1.0f );
    
	shaderManager.InitializeStockShaders();

	// adowanie trjkta
	GLfloat vVerts[] = { -0.5f, 0.0f, 0.0f, 
		                  0.5f, 0.0f, 0.0f,
						  0.0f, 0.5f, 0.0f };

	triangleBatch.Begin(GL_TRIANGLES, 3);
	triangleBatch.CopyVertexData3f(vVerts);
	triangleBatch.End();
	}



///////////////////////////////////////////////////////////////////////////////
// Wywoanie sceny
void RenderScene(void)
	{
	// Czyszczenie okna aktualnie wyznaczonym do tego celu kolorem
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

	GLfloat vRed[] = { 1.0f, 0.0f, 0.0f, 1.0f };
	shaderManager.UseStockShader(GLT_SHADER_IDENTITY, vRed);
	triangleBatch.Draw();

	// Zamiana buforw w celu wywietlenia zawartoci bufora tylnego
	glutSwapBuffers();
	}


///////////////////////////////////////////////////////////////////////////////
// Gwny punkt pocztkowy programu opartego na bibliotece GLUT
int main(int argc, char* argv[])
	{
	gltSetWorkingDirectory(argv[0]);
	
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH | GLUT_STENCIL);
	glutInitWindowSize(800, 600);
	glutCreateWindow("Trjkt");
    glutReshapeFunc(ChangeSize);
    glutDisplayFunc(RenderScene);

	GLenum err = glewInit();
	if (GLEW_OK != err) {
		fprintf(stderr, "Bd GLEW: %s\n", glewGetErrorString(err));
		return 1;
		}
	
	SetupRC();

	glutMainLoop();
	return 0;
	}
